@echo off
:: PicoHarp 330 SEQ demo for calling a python script by way of a batch file

:: Display the path+name of the batch file
echo %0 
:: Display the call parameters
echo Batch file called with parameters p1=%1 p2=%2 
 
:: The PicoHarp 330 software will always start a sequence with 
:: p1=0 and increment it at each new call, up to the 
:: maximum of 511, corresponding to the max number of 
:: 512 curves in a PHU file.

:: Next we want to call the python script and pass the parameters.
:: We could specify the full path of the python script but
:: it is more convenient to have it sitting in the same folder
:: as the batch file and use the path of that like so:
set scriptpath=%~dp0

:: Then we can call it and pass the parameters like this:
python "%scriptpath%seqdemo.py" %1 %2
:: Note that this requires that python is on the Windows path.
:: Otherwise you would have to specify the full path for it.

:: Finally we retrieve what the python script returned via exit(x)
set /a returncode = %ERRORLEVEL%
echo returncode was %returncode%
:: By convention a negative return code indicated an error which 
:: tells the PicoHarp software to terminate the sequence run.
:: A positive or zero return code indicates success and the
:: return code is stored in the SEQ mode data file as p3.
:: You may want to use this to encode e.g. the wavelenght setting
:: of a monochromator you script might be controlling.

:: A problem is that python will return 1 in case of syntax errors
:: and it will return 2 when the script is not found.
:: If you can keep your 'meaningful' returncodes above 2 then
:: it makes sense to re-map these error codes to negative values
:: in order to terminate the sequence run. This goes like so:
if %returncode%==1 (set /a returncode = -1)
if %returncode%==2 (set /a returncode = -2)

echo final returncode is %returncode%
::you may want to pause here for debug purposes
::pause

:: This returncode we pass on to the PicoHarp software where 
:: it will be stored as p3 in the SEQ mode file.
exit %returncode%
